*
* Example of Kalman smoothing
*
open data nile.dat
calendar 1871
data(format=free,org=columns,skips=1) 1871:1 1970:1 nile
*
dlm(a=1.0,c=1.0,sv=15099.0,sw=1469.1,presample=diffuse,y=nile,$
  type=smooth) / xstates vstates
set a     = %scalar(xstates)
set p     = %scalar(vstates)
set lower = a+sqrt(p)*%invnormal(.05)
set upper = a+sqrt(p)*%invnormal(.95)
*
graph(footer="Figure 1. Smoothed state and 90% confidence intervals") 4
# nile
# a
# lower / 3
# upper / 3

